#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/fsV3WD

#define pi 3.1415926535
#define STEPS 500.0
#define MDIST 200.0
#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))
#define pmod(p,x) (mod(p,x)-0.5*(x))
float h21(vec2 a){
    return fract(sin(dot(a,vec2(453.2734,255.4363)))*994.3434);
}
vec3 rdg;
float box(vec3 p, vec3 b){
    vec3 d= abs(p)-b;
    return max(d.x,max(d.y,d.z));
}
vec3 map(vec3 p){
    vec3 po = p;
    vec2 a = vec2(1);
    //vec2 b = vec2(2);
    float t =iTime;
    p.x+=t;
    
    float m = 2.; //Adjust the sphere size here :)
    
    vec2 id3 = floor(p.xz/m)+0.5;
    p.x+=id3.y;
    vec2 id2 = floor(p.xz/m)+0.5;
    float hash =h21(mod(id2,100.0));
    p.y+=(hash-0.5);
    id2*=rot(-pi/6.0);
    p.y+=sin(id2.x+t)*0.7;
    p.y+=sin(id2.x*0.6+t)*0.4;
    p.y+=sin(id2.x*0.3+t)*0.2;
    id2*=rot(pi/6.0)*0.3;
    p.y+=sin(id2.y+t)*0.7;
    po = p;
    float dc = 0.;
    {
        vec3 p2=p/vec3(m);
        vec3 id = floor(p2);
        vec3 dir = sign(rdg)*.5;
        vec3 q = fract(p2)-.5;
        vec3 rc = (dir-q)/rdg;
        rc*=m;
        dc = min(rc.x,min(rc.y,rc.z))+0.01;
    }
    p.xz = pmod(p.xz,m);
    t+=hash*200.;
    //t*=-1.;
    //////////////////////////////////
    //////////////////////////////////
    float spd = .025;
    t*=spd;
    float lscl = m;
    float le = -mod(t * lscl,lscl); 
    float tscl = 650.; 
    float te = tscl - mod(t * tscl,tscl); 
    float scl = 0.; 
    float id = 0.;
    float npy = 0.;
    bool mid = false;
        if(p.y > le && p.y < te){ 
            npy = mod(p.y-le,tscl);
            scl = mix(tscl,lscl,min(fract(t)*2.0,1.0));
            mid = true;
            id = floor(t);
        }
        if(p.y<le){ 
            npy = mod(p.y-le,lscl);
            id = floor((p.y-le)/lscl)+floor(t);
            scl = lscl;
        }
        if(p.y>te){ 
            npy = mod(p.y-te,tscl);           
            id = floor((p.y-te)/tscl)+floor(t)+1.0; 
            scl = tscl;
            //mid = true;
        }
        npy-=scl*0.5;
        p.y = npy;
    //////////////////////////////////
    //////////////////////////////////
    
    a.x = length(p)-m*0.98*0.5;
    
    a.x = max(-po.z-16.,a.x);
    float c = a.x;
    a.x = min(a.x,dc);
    
    if(mid)a.x = min(a.x,max(-(-po.y+le),0.1));
    a.y = id;
    return vec3(a,c);
}
vec3 norm(vec3 p){
    vec2 e = vec2(0.01,0.);
    return normalize(map(p).x-vec3(
    map(p-e.xyy).x,
    map(p-e.yxy).x,
    map(p-e.yyx).x));
}
vec3 light(vec3 p, vec3 rd){
    vec3 col = vec3(0);
    vec3 ld = normalize(vec3(1,1,-1));
    vec3 n = norm(p);
    float fres = 1.-abs(dot(rd,n))*.6;
    col = vec3(clamp(fres,0.,1.));
    
    float sss = 0.6;
        for(float i=1.; i<40.; ++i){
        float dist = i*0.1;
        sss += 0.04*smoothstep(0.,1.,map(p+ld*dist).z/dist);
    }
    col*=sss;
    
    vec3 p2 = p;
    p2.xz*=rot(0.1+cos(iTime*0.2)*0.3);
    col*=mix(vec3(0.310,0.471,0.953),vec3(0.106,0.137,0.553),sin(p2.z+p2.x)*0.5+0.5);
    return col;
}
void mainImage( out vec4 fragColor, in vec2 fragCoord ){
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
    vec3 col = vec3(0);
    
    vec3 ro = vec3(1,10,-25);
    vec3 lk = vec3(1.01,2,0);
    vec3 f = normalize(lk-ro);
    vec3 r = normalize(cross(vec3(0,1,0),f));
    vec3 rd = normalize(f*0.95+uv.x*r+uv.y*cross(f,r));
    rdg=rd;
    vec3 p = vec3(0);
    vec3 d = vec3(0);
    float dO = 0.;
    bool hit = false;
    for(float i =0.; i<STEPS; i++){
        p = ro+rd*dO;
        d = map(p);
        dO += d.x*1.25;
        if(abs(d.x)<0.005){
            hit =true;
            break;
        }
        if(dO>MDIST){
            dO=MDIST;
            p = ro+rd*dO;
            break;
        }   
    }
    if(hit){
        col = light(p,rd);
    }

    //Fog
    col*=clamp(p.y*0.15+1.0,-1.,1.);
    col = pow(col,vec3(0.6));;
    vec3 bg = mix(vec3(0.000,0.12,0.400),vec3(0.439,0.784,1.000),max(rd.y+0.6,0.));
    col = mix(col,bg,clamp(length(p-ro*0.5)/60.,0.,1.));

    fragColor = vec4(col,0.0);
}




///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


